<?php

namespace App\Http\Controllers\owner\rbac;

use Illuminate\Session\Store;
use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\rbac\Permission;
use App\Models\rbac\Module;
use App\Models\rbac\Role;
use App\Models\rbac\ModuleRolePermission;
use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;

class ModuleRolePermissionController extends OwnerBaseController {

      public function __construct(Store $session){
        parent::__construct($session);
    }

    public function manage_permission_grid(Request $req) {

        //  dd($req->id);
        $role_id = $req->id;
        $row = Role::where('id','=',$role_id)->first();
        
        $module_and_permissions = Module::with('module_permissions')->where('belongs_to', '=','school')->where('status', '=', 1)->get();
        $module_role_permissions = ModuleRolePermission::where('role_id', '=', $role_id)->get();

        $existing_permission_array = array();
        if (!empty($module_role_permissions) && count($module_role_permissions) > 0) {
            //  dd($module_role_permissions); 
            $existing_permission_array = array();
            foreach ($module_role_permissions as $mrp) {
                array_push($existing_permission_array, $mrp->permission_id);
            }
        }
//dd($row);
        return view('owner.rbac.module_role_permission.module_role_permission_grid', [
            'module_and_permissions' => $module_and_permissions,
            'module_role_permissions' => $module_role_permissions,
            'existing_permission_array' => $existing_permission_array,
            'role_id' => $role_id,
            'row' => $row,
        ]);
    }

    public function sync_module_role_permission(Request $request) {
        //  dd($request->post());

        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $owner = Permission::find($id); */

        $v = Validator::make($data, [
                    'module_permission' => ['required'],
                    'role_id' => ['required', 'integer'],
        ]);


        //dd($v->errors());
        if ($v->fails()) {
//             flash_messages::add_message('e',$v->errors()->all());
//            return flash_messages::display_message(true);          
            return redirect()->back()->withErrors($v)->withInput($data);
        }

        $role_id = $data['role_id'];


        if (!empty($data['module_permission']) && count($data['module_permission']) > 0) {
            $module_permissions = $data['module_permission'];
            $delete_existing = ModuleRolePermission::where('role_id', '=', $role_id)->delete();

            $insert_data = array();
            foreach ($module_permissions as $module_permission) {
                $module_permission = explode('|', $module_permission);
                $module_id = $module_permission[0];
                $permission_id = $module_permission[1];
                $insert_one = array('role_id' => $role_id, 'module_id' => $module_id, 'permission_id' => $permission_id);
                array_push($insert_data, $insert_one);
            }

            $save = ModuleRolePermission::insert($insert_data);
            // dd($save);
            if ($save) {
                return redirect()->back()->withSuccess('Pemissions synced successfully');
            } else {
                return redirect()->back()->withErrors('Cannot sync permissions')->withInput($data);
            }
        } else {
            $check_existing = ModuleRolePermission::where('role_id', '=', $role_id)->get();
            if (!empty($check_existing) && count($check_existing) > 0) {
                $delete_existing = ModuleRolePermission::where('role_id', '=', $role_id)->delete();
                return redirect()->back()->withSuccess('Pemissions synced successfully')->withInput($data);
            } else {
                return redirect()->back()->withErrors('Cannot sync permissions')->withInput($data);
            }
        }
    }

}
