<?php
    
namespace App\Http\Controllers\owner\rbac;

use Illuminate\Session\Store;
use App\Http\Controllers\owner\OwnerBaseController ;

use Illuminate\Http\Request;


use App\Models\rbac\Module;

use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages ;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;


  
class ModuleController extends OwnerBaseController
{
    

    public function __construct(Store $session){
        parent::__construct($session);
      
    }

    public function roles(Request $request) {
        //dd($request->all());
        $owner = Module::findorfail($request->owner_id);
        //dd($owner);
        $owner->syncRoles($request->roles);
        return redirect('owner/module')->with('success', 'Roles added successfully!');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {

        return view('owner.rbac.module.index');
    }

      public function module_grid(Request $req) {        
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');        
           
        $search_coloumns = ['m_name','id','m_code'];
            if(!empty($search_term)){
                $rows = Module::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                           $q->orWhere($field, 'like', "%{$search_term}%");
                })->where('id', '>=', 1)->paginate($limit);
            }else{
                $rows = Module::where('id', '>=', 1)->paginate($limit); 
             }
    
        return view('owner.rbac.module.module_grid',['result_data'=>$rows]);
    }  
    

    
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {   
        return view('owner.rbac.module.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
            'name' => ['required', 'string', 'min:2','max:100'],
            'code' => ['required', 'string', 'min:2', 'max:128'],
              'status' => ['required', 'integer'],
         
        ]);


        //dd($v->errors());
    
         if ($v->fails()) {
            if($request->ajax()){
               flash_messages::add_message('e', $v->errors()->all());
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error', $v->errors()->all());
        
        }
        

        $m_code = slugify_underscore($data['code']);
          $check_module = $this->check_unique_module($m_code,$id=0);    
        if(!empty($check_module->m_code)){
            $status = config('constants.GENERAL_STATUS');
            $state = $status[$check_module['status']];
            
              if($request->ajax()){
             flash_messages::add_message('e', 'This module already exists and in '.$state.' State. Kindly contact change module code');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error','This module already exists and in '.$state.' State. Kindly contact change module code');
            
            
        
            
           // return redirect()->back()->withErrors('This email already taken and in '.$state.' State. Kindly contact Administrator')->withInput($data);  
        }     
        
       
      
        
        
        $module = new Module();
        $module->m_name = $request->name;
        $module->m_code = slugify_underscore($request->code);
      
       $module->status = $request->status;
       $module->m_description = $request->description;
    
        $module->save();

      
        if ($module->id) {           
             if($request->ajax()){
             flash_messages::add_message('s', 'Module added successfully!');
            return flash_messages::display_message(true);
            }            
           return redirect('owner/employee')->with('success','Module added successfully!');           
        } else {
            
              if($request->ajax()){
             flash_messages::add_message('e', 'Unable to add Module. Please try again!');
            return flash_messages::display_message(true);
            }   
           return redirect()->back()->with('error','Unable to add Module. Please try again!');       
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
    
         $row = Module::findOrFail($id);

   
        return view('owner.module.show', [
            'row' => $row, 
       //     'Role' => $Role, 
            
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
      
        $row = Module::findOrFail($id);

        return view('owner.rbac.module.edit', [
            'row' => $row, 
            
           
        ]);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {

        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /*$owner = Module::find($id);*/

       $v = Validator::make($data, [
            'name' => ['required', 'string', 'min:2','max:100'],
            'code' => ['required', 'string', 'min:2','max:100'],
            'status' => ['required', 'integer'],
              
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           if($request->ajax()){
               flash_messages::add_message('e', $v->errors()->all());
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error', $v->errors()->all());
        }

        
              $m_code = slugify_underscore($data['code']);
          $check_module = $this->check_unique_module($m_code,$id);    
        if(!empty($check_module->m_code)){
            $status = config('constants.GENERAL_STATUS');
            $state = $status[$check_module['status']];
            
                    if($request->ajax()){
             flash_messages::add_message('e', 'This module already exists and in '.$state.' State. Kindly contact change module code');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error','This module already exists and in '.$state.' State. Kindly contact change module code');
           
        }     
    //  dd($request->description);
        
        $check = Module::findorfail($id);
        //$owner->assignRole($request->role);



           $save =  Module::where('id', $id)->update([
            'm_name'  => $data['name'],
           // 'm_code'  => $data['code'],
            'status'  => $data['status'],
                'm_description' => $request->description
            
        ]);

              if($request->ajax()){
             flash_messages::add_message('s', 'Updated successfully!');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('success','Updated successfully!');     
            

       // return redirect()->back()->with('success', 'Data updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        $row = Module::where('id', $id)->first();
        if($row->role == 'owner') {
            return redirect('owner/module')->with('error', 'Admin owners can not be deleted');
        }
        $row->status = '2';
        $row->delete();
        return redirect('owner/module')->with('success', 'Module deleted successfully!');
    }


    public function check_unique_module($m_code,$id=0) {
        $row = Module::where('m_code', $m_code)->where('id',"!=" ,$id)->first();
        return $row;
    }
    
    
 
}