<?php
    
namespace App\Http\Controllers\owner;
   
use Illuminate\Session\Store;
use App\Http\Controllers\owner\OwnerBaseController ;

use Illuminate\Http\Request;


use App\Models\SiteSetting;

use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages ;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

use View;


  
class SiteSettingController extends OwnerBaseController
{
    

    public function __construct(Store $session){
        parent::__construct($session);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//
//        $table_name = SiteSetting::getTableName();

//        $Role = Role::all();
//
//        $conditions = array();

//
//        
//       $rows = SiteSetting::whereDoesntHave('roles', function ($query) {
//    $query->where('name','=', 'customer')->orWhere('name','=', 'vendor');
//})->where($conditions)->orderBy('id', 'desc')->get();
//        //dd($rows);
//        
//        
        
       // dd($this->get_site_setting());
        

        return view('owner.site_setting.index');
    }

      public function site_setting_grid(Request $req) {        
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');        
        $search_coloumns = ['site_name','id'];
            if(!empty($search_term)){
                $rows = SiteSetting::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                           $q->orWhere($field, 'like', "%{$search_term}%");
                })->where('id', '>=', 1)->paginate($limit);
            }else{
                $rows = SiteSetting::where('id', '>=', 1)->paginate($limit); 
             }
    
        return view('owner.site_setting.site_setting_grid',['result_data'=>$rows]);
    }  
    

    
   

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
     //   return redirect('owner/owner/'.$id.'/edit');
        //$row = SiteSetting::where('id', $id)->first();
         $row = SiteSetting::findOrFail($id);

     
        return view('owner.site_setting.show', [
            'row' => $row, 
       //     'Role' => $Role, 
            
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       

        $row = SiteSetting::findOrFail($id);


        return view('owner.site_setting.edit', [
            'row' => $row, 
            
           
        ]);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {

        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /*$owner = SiteSetting::find($id);*/

       $v = Validator::make($data, [
            'name' => ['required', 'string', 'min:2','max:100'],
            'email' => ['required', 'string', 'email', 'max:128'],
            'mobile' => ['required', 'string', 'min:10', 'max:10'],
          //  'site_layout' => ['required'],
         //   'site_skin' => ['required'],
               
        ]);

//dd($data);
        //dd($v->errors());
        if ($v->fails()) {
             flash_messages::add_message('e',$v->errors()->all());
            return flash_messages::display_message(true);          
         //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

 
        
        $setting = SiteSetting::findorfail($id);
        //$owner->assignRole($request->role);
//
//        $old_vendor_status = $owner->vendor_status;
//        $new_vendor_status = $request->vendor_status;

        
        $body = '';
  $main_header = '';
  $nav_sidebar = '';
  $main_sidebar = '';
  $brand_link = '';
  $main_footer = '';
  
  if(!empty($data['site_theme'])){
      $exploded = explode('|',$data['site_theme']);
      $class_element = $exploded[0];
      $class = $exploded[1];
     $$class_element .= ' '.$class;
  }
  
  if(!empty($data['header_options'])){
      $header_options = $data['header_options'];
      foreach($header_options as $option){
           $exploded = explode('|',$option);
      $class_element = $exploded[0];
      $class = $exploded[1];
     $$class_element .= ' '.$class;
      }
  }
  
  
  if(!empty($data['sidebar_options'])){
      $sidebar_options = $data['sidebar_options'];
      foreach($sidebar_options as $option){
           $exploded = explode('|',$option);
      $class_element = $exploded[0];
      $class = $exploded[1];
     $$class_element .= ' '.$class;
      }
  }
  if(!empty($data['footer_options'])){
      $footer_options = $data['footer_options'];
      foreach($footer_options as $option){
           $exploded = explode('|',$option);
      $class_element = $exploded[0];
      $class = $exploded[1];
     $$class_element .= ' '.$class;
      }
  }
  if(!empty($data['small_text_options'])){
      $small_text_options = $data['small_text_options'];
      foreach($small_text_options as $option){
           $exploded = explode('|',$option);
      $class_element = $exploded[0];
      $class = $exploded[1];
     $$class_element .= ' '.$class;
      }
  }
   if(!empty($data['navbar_skins'])){
      $exploded = explode('|',$data['navbar_skins']);
      $class_element = $exploded[0];
      $class = $exploded[1];
     $$class_element .= ' '.$class;
  }
   if(!empty($data['sidebar_skins'])){
      $exploded = explode('|',$data['sidebar_skins']);
      $class_element = $exploded[0];
      $class = $exploded[1];
      $exploded_card_haeder = explode('-',$exploded[1]);
      $default_card_headr_class = $exploded_card_haeder[2];
     $$class_element .= ' '.$class;
  }
   if(!empty($data['brand_logo_colours'])){
      $exploded = explode('|',$data['brand_logo_colours']);
      $class_element = $exploded[0];
      $class = $exploded[1];
     $$class_element .= ' '.$class;
  }
  
   if(!empty($data['accent_colours'])){
      $exploded = explode('|',$data['accent_colours']);
      $class_element = $exploded[0];
      $class = $exploded[1];
     $$class_element .= ' '.$class;
  }
  
  
  
   $body_class= $body ;
  $main_header_class= $main_header ;
  $nav_sidebar_class= $nav_sidebar ;
  $main_sidebar_class= $main_sidebar ;
  $brand_link_class= $brand_link ;
  $main_footer_class= $main_footer ;
  
     //  dd($main_sidebar) ;
        
        SiteSetting::where('id', $id)->update([
            'site_name'  => $data['name'],
//            'site_layout_class'  => $data['site_layout'],
//            'site_skin_class'  => $data['site_skin'],
//            'site_label_text_class'  => $data['lable_text_class'],
            'body_class'  => $body_class,
            'main_header_class'  => $main_header_class,
            'nav_sidebar_class'  => $nav_sidebar_class,
            'main_sidebar_class'  => $main_sidebar_class,
            'brand_link_class'  => $brand_link_class,
            'main_footer_class'  => $main_footer_class,
            'default_card_header_class'  => $default_card_headr_class,
            
        ]);

    

           if($request->ajax()){
             flash_messages::add_message('s', 'Updated successfully!');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('success','Updated successfully!');

       // return redirect()->back()->with('success', 'Data updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    
   
   
}