<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Session;

use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\ScaffoldingProduct as ScaffoldingProduct;

use DB;

use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;
use Carbon\Carbon;

class ScaffoldingProductController extends OwnerBaseController {

    public function __construct(Store $session){
        parent::__construct($session);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//


 //check_permission('owner_scaffolding_product|view_scaffolding_product');
        return view('owner.scaffolding_product.index');
    }

    public function scaffolding_product_grid(Request $req) {
     //  check_permission('owner_scaffolding_product|view_scaffolding_product');
       
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
        $search_coloumns = ['name'];
        if (!empty($search_term)) {
            $rows = ScaffoldingProduct::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })->where('id', '>=', 1)
                   
                  
                    ->paginate($limit);
        } else {
            $rows = ScaffoldingProduct::where('id', '>=', 1)
                 
                 
                    ->paginate($limit);
        }
//dd($rows);
        return view('owner.scaffolding_product.scaffolding_product_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       //check_permission('owner_scaffolding_product|create_scaffolding_product');
        
       $scaffolding_products = ScaffoldingProduct::where('status',1)->get();
        return view('owner.scaffolding_product.create', [
          'scaffolding_products'=>$scaffolding_products,
        ]);
    }


    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
      // check_permission('owner_scaffolding_product|create_scaffolding_product');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'name' => ['required', 'string', 'min:2', 'max:100'],
                 
                    'status' => ['required', 'integer', 'max:99'],
                    'image' => 'required|image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
            
           flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

       

        
        
        
        
        
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard($this->guard_name)->user()->id;
    //  dd($userid);

        

        $scaffolding_product = new ScaffoldingProduct();
        
        $scaffolding_product->name = $request->name;
      
        $scaffolding_product->status = $request->status;
      
      $scaffolding_product->save();

      

        if ($scaffolding_product->id){
            $scaffolding_product_id = $scaffolding_product->id;
            if ($request->hasFile('scaffolding_product_image')) {
                $file = $request->file('scaffolding_product_image');
                $time = time();
                if ($file->isValid()) {
                    $ext = strtolower($file->extension());
                    $file_name = "img" . "_" . $scaffolding_product_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('scaffolding_product/scaffolding_product_image', $file_name);
                    $scaffolding_product->image = $path;
                    $scaffolding_product->save();
                }
            }
            
          
            
            
        }
        
      DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
     flash_messages::add_message('s', 'Saved successfully!');
        return flash_messages::display_message($request, $url = "owner/scaffolding_product");
        
           
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
             flash_messages::add_message('e', 'Unable to add Image. Please try again!'.$exp);
        return flash_messages::display_message($request, $url = "back");
            
           
        }
        
        
        
        
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
      // check_permission('owner_scaffolding_product|view_scaffolding_product');
        
        $row = ScaffoldingProduct::findOrFail($id);

      
        return view('owner.scaffolding_product.show', [
            'row' => $row,
           
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       //check_permission('owner_scaffolding_product|edit_scaffolding_product');

        $row = ScaffoldingProduct::findOrFail($id);
      
     $scaffolding_products = ScaffoldingProduct::where('status',1)->get();
        return view('owner.scaffolding_product.edit', [
            'row' => $row,
            'scaffolding_products' => $scaffolding_products,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
      // check_permission('owner_scaffolding_product|edit_scaffolding_product');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $scaffolding_product = ScaffoldingProduct::find($id); */

        $v = Validator::make($data, [
                     'name' => ['required', 'string', 'min:2', 'max:100'],
                                   
                    'status' => ['required', 'integer', 'max:99'],
                    'image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           
                flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            
            
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        try {
             DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction

               $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');
               $userid = Auth::guard('owner')->user()->id;
           //  dd($userid);



          $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');

               $scaffolding_product = ScaffoldingProduct::findorfail($id);
               //$scaffolding_product->assignRole($request->role);
                $scaffolding_product->name = $request->name;
                
               $scaffolding_product->status = $request->status;
              

              $scaffolding_product->save();

               $scaffolding_product_id = $id;
               
                
               if ($request->hasFile('scaffolding_product_image')) {
                   $file = $request->file('scaffolding_product_image');
                   $time = time();
                   if ($file->isValid()) {
//                        $filename_to_delete = storage_path() . '/app/private/' . $scaffolding_product->image;
//  dd($filename_to_delete);
                       $filename_to_delete = storage_path() . '/app/private/' . $scaffolding_product->image;
                     
                       @unlink($filename_to_delete);

                       $ext = strtolower($file->extension());
                       $file_name = "img" . "_" . $scaffolding_product_id . "_" . $time . "." . $ext;
                       $path = $file->storeAs('scaffolding_product/scaffolding_product_image', $file_name);
                       // dd($path);
                       $scaffolding_product->image = $path;
                       $scaffolding_product->save();
                       // save in database
                   }
               }

               
                 
         
            
                       DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
                       flash_messages::add_message('s','Updated successfully!');
                       return flash_messages::display_message($request, $url = "back");



               } catch(\Exception $exp) {
                   DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                   flash_messages::add_message('e', 'Unable to update Scaffolding Product details. Please try again!'.$exp);
                   return flash_messages::display_message($request, $url = "back");   

               }
         
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
      // check_permission('owner_scaffolding_product|delete_scaffolding_product');
        
        $row = ScaffoldingProduct::where('id', $id)->first();
      
        $row->status = '2';
        $row->save();
        return redirect('owner/scaffolding_product')->with('success', 'ScaffoldingProduct deleted successfully!');
    }


}
