<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Session;

use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\ScaffoldingCategory as ScaffoldingCategory;

use DB;

use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;
use Carbon\Carbon;

class ScaffoldingCategoryController extends OwnerBaseController {

    public function __construct(Store $session){
        parent::__construct($session);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//


 //check_permission('owner_scaffolding_category|view_scaffolding_category');
        return view('owner.scaffolding_category.index');
    }

    public function scaffolding_category_grid(Request $req) {
     //  check_permission('owner_scaffolding_category|view_scaffolding_category');
       
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
        $search_coloumns = ['title', 'description', 'link'];
        if (!empty($search_term)) {
            $rows = ScaffoldingCategory::with('parent_category')->where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })
                            ->where('id', '>=', 1)
                            ->orderBy('status', 'DESC')
                   
                  
                    ->paginate($limit);
        } else {
            $rows = ScaffoldingCategory::with('parent_category')
                    ->where('id', '>=', 1)
                    ->orderBy('status', 'DESC')
                 
                 
                    ->paginate($limit);
        }
//dd($rows);
        return view('owner.scaffolding_category.scaffolding_category_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       //check_permission('owner_scaffolding_category|create_scaffolding_category');
        
       $categories = ScaffoldingCategory::where('status',1)->get();
        return view('owner.scaffolding_category.create', [
          'categories'=>$categories,
        ]);
    }


    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
      // check_permission('owner_scaffolding_category|create_scaffolding_category');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'title' => ['required', 'string', 'min:2', 'max:100'],
                    'parent_id' => ['required', 'integer'],
            'sort_order' => ['required', 'integer'],
             'small_description' => ['string', 'min:2', 'max:255'],                   
                     'link' => ['string',  'max:255'],         
                    'status' => ['required', 'integer', 'max:99'],
                    'image' => 'image|mimes:jpeg,jpg|max:5120',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
            
           flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

       

        
        
        
        
        
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard($this->guard_name)->user()->id;
    //  dd($userid);

        

        $scaffolding_category = new ScaffoldingCategory();
        
        $scaffolding_category->title = $request->title;
        $scaffolding_category->slug = slugify($request->title);
              $scaffolding_category->parent_id = $request->parent_id;
                $scaffolding_category->small_description = $request->small_description;
              $scaffolding_category->description = $request->description;
              $scaffolding_category->sort_order = $request->sort_order;
              $scaffolding_category->free_text_one = $request->free_text_one;
              $scaffolding_category->free_text_two = $request->free_text_two;
              $scaffolding_category->free_text_three = $request->free_text_three;
              $scaffolding_category->link = $request->link;
        $scaffolding_category->status = $request->status;
       
        $scaffolding_category->updated_by = $userid;
        $scaffolding_category->updated_at = $current_timestamp;
        $scaffolding_category->created_by = $userid;
        $scaffolding_category->created_at = $current_timestamp;
       
    $scaffolding_category->save();

      

        if ($scaffolding_category->id){
            $scaffolding_category_id = $scaffolding_category->id;
            if ($request->hasFile('scaffolding_category_image')) {
                $file = $request->file('scaffolding_category_image');
                $time = time();
                if ($file->isValid()) {
                    $ext = strtolower($file->extension());
                    $file_name = "img" . "_" . $scaffolding_category_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('scaffolding_category/scaffolding_category_image', $file_name);
                    $scaffolding_category->image = $path;
                    $scaffolding_category->save();
                }
            }
            
            if ($request->hasFile('image_two')) {
                $file = $request->file('image_two');
                $time = time();
                if ($file->isValid()) {
                    $ext = strtolower($file->extension());
                    $file_name = "img2" . "_" . $scaffolding_category_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('scaffolding_category/scaffolding_category_image', $file_name);
                    $scaffolding_category->image_two = $path;
                    $scaffolding_category->save();
                }
            }
            
            if ($request->hasFile('image_three')) {
                $file = $request->file('image_three');
                $time = time();
                if ($file->isValid()) {
                    $ext = strtolower($file->extension());
                    $file_name = "img3" . "_" . $scaffolding_category_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('scaffolding_category/scaffolding_category_image', $file_name);
                    $scaffolding_category->image_three = $path;
                    $scaffolding_category->save();
                }
            }
            
            
        }
        
      DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
     flash_messages::add_message('s', 'Saved successfully!');
        return flash_messages::display_message($request, $url = "owner/scaffolding_category");
        
           
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
             flash_messages::add_message('e', 'Unable to add Image. Please try again!'.$exp);
        return flash_messages::display_message($request, $url = "back");
            
           
        }
        
        
        
        
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
      // check_permission('owner_scaffolding_category|view_scaffolding_category');
        
        $row = ScaffoldingCategory::findOrFail($id);

      
        return view('owner.scaffolding_category.show', [
            'row' => $row,
           
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       //check_permission('owner_scaffolding_category|edit_scaffolding_category');

        $row = ScaffoldingCategory::findOrFail($id);
      
     $categories = ScaffoldingCategory::where('status',1)->get();
        return view('owner.scaffolding_category.edit', [
            'row' => $row,
            'categories' => $categories,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
      // check_permission('owner_scaffolding_category|edit_scaffolding_category');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $scaffolding_category = ScaffoldingCategory::find($id); */

        $v = Validator::make($data, [
                     'title' => ['required', 'string', 'min:2', 'max:100'],
                     'parent_id' => ['required', 'integer'],                   
                     'sort_order' => ['required', 'integer'],                   
                  //   'description' => ['string'],                   
                     'link' => ['string', 'min:2', 'max:255'],                   
                    'status' => ['required', 'integer', 'max:99'],
                    'image' => 'image|mimes:jpeg,jpg|max:5120',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           
                flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            
            
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        try {
             DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction

               $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');
               $userid = Auth::guard('owner')->user()->id;
           //  dd($userid);



          $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');

               $scaffolding_category = ScaffoldingCategory::findorfail($id);
               //$scaffolding_category->assignRole($request->role);
                $scaffolding_category->title = $request->title;
                $scaffolding_category->slug = slugify($request->title);
              $scaffolding_category->parent_id = $request->parent_id;
              $scaffolding_category->small_description = $request->small_description;
              $scaffolding_category->description = $request->description;
              $scaffolding_category->sort_order = $request->sort_order;
              $scaffolding_category->free_text_one = $request->free_text_one;
              $scaffolding_category->free_text_two = $request->free_text_two;
              $scaffolding_category->free_text_three = $request->free_text_three;
              $scaffolding_category->link = $request->link;
               $scaffolding_category->status = $request->status;
               $scaffolding_category->updated_by = $userid;
               $scaffolding_category->updated_at = $current_timestamp;
               $scaffolding_category->created_by = $userid;
               $scaffolding_category->created_at = $current_timestamp;


               $scaffolding_category->save();

               $scaffolding_category_id = $id;

               if ($request->hasFile('scaffolding_category_image')) {
                   $file = $request->file('scaffolding_category_image');
                   $time = time();
                   if ($file->isValid()) {

                       $filename_to_delete = storage_path() . '/app/' . $scaffolding_category->image;
                       @unlink($filename_to_delete);

                       $ext = strtolower($file->extension());
                       $file_name = "img" . "_" . $scaffolding_category_id . "_" . $time . "." . $ext;
                       $path = $file->storeAs('scaffolding_category/scaffolding_category_image', $file_name);
                       // dd($path);
                       $scaffolding_category->image = $path;
                       $scaffolding_category->save();
                       // save in database
                   }
               }

               
                   if ($request->hasFile('image_two')) {
                $file = $request->file('image_two');
                $time = time();
                if ($file->isValid()) {
                    
                     $filename_to_delete = storage_path() . '/app/' . $scaffolding_category->image_two;
                     @unlink($filename_to_delete);
                       
                    $ext = strtolower($file->extension());
                    $file_name = "img2" . "_" . $scaffolding_category_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('scaffolding_category/scaffolding_category_image', $file_name);
                    $scaffolding_category->image_two = $path;
                    $scaffolding_category->save();
                }
            }
            
            if ($request->hasFile('image_three')) {
                $file = $request->file('image_three');
                $time = time();
                if ($file->isValid()) {
                     $filename_to_delete = storage_path() . '/app/' . $scaffolding_category->image_three;
                       @unlink($filename_to_delete);
                       
                    $ext = strtolower($file->extension());
                    $file_name = "img3" . "_" . $scaffolding_category_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('scaffolding_category/scaffolding_category_image', $file_name);
                    $scaffolding_category->image_three = $path;
                    $scaffolding_category->save();
                }
            }
            
                       DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
                       flash_messages::add_message('s','Updated successfully!');
                       return flash_messages::display_message($request, $url = "back");



               } catch(\Exception $exp) {
                   DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                   flash_messages::add_message('e', 'Unable to update scaffolding_category details. Please try again!'.$exp);
                   return flash_messages::display_message($request, $url = "back");   

               }
         
        
        
        
        
        
        
        
        
       
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
      // check_permission('owner_scaffolding_category|delete_scaffolding_category');
        
        $row = ScaffoldingCategory::where('id', $id)->first();
      
        $row->status = '2';
        $row->save();
        return redirect('owner/scaffolding_category')->with('success', 'ScaffoldingCategory deleted successfully!');
    }


}
