<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Session;

use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\Project as Project;

use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;
use Carbon\Carbon;

class ProjectController extends OwnerBaseController {

    public function __construct(Store $session){
        parent::__construct($session);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//


 //check_permission('owner_project|view_project');
        return view('owner.project.index');
    }

    public function project_grid(Request $req) {
     //  check_permission('owner_project|view_project');
        
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
        $search_coloumns = ['name', 'id', 'email'];
        if (!empty($search_term)) {
            $rows = Project::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })->where('id', '>=', 1)
                   
                  
                    ->paginate($limit);
        } else {
            $rows = Project::where('id', '>=', 1)
                 
                 
                    ->paginate($limit);
        }

        return view('owner.project.project_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       //check_permission('owner_project|create_project');
        
       
        return view('owner.project.create', [
          
        ]);
    }


    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
      // check_permission('owner_project|create_project');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'title' => ['required', 'string', 'min:2', 'max:100'],
                    'category' => ['required', 'string', 'min:2', 'max:50'],
                    'description' => ['required', 'string'],
                    'status' => ['required', 'integer', 'max:99'],
                    'project_image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
            
           flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

       

        
        
        
        
        
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard($this->guard_name)->user()->id;
    //  dd($userid);

        

        $project = new Project();
        $project->title = $request->title;
        $project->category = $request->category;
        $project->description = $request->description;  
        $project->status = $request->status;
        $project->updated_by = $userid;
        $project->updated_at = $current_timestamp;
        $project->created_by = $userid;
        $project->created_at = $current_timestamp;
       
        $project->save();

      

        if ($project->id) {
            $project_id = $project->id;
            
            if ($request->hasFile('project_image')) {
                $file = $request->file('project_image');
                $time = time();
                if ($file->isValid()) {
                    $ext = strtolower($file->extension());
                    $file_name = "img" . "_" . $project_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('project/project_image', $file_name);
                    $project->image = $path;
                    $project->save();
                }
            }

           
            
           
        }
        
      DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
     flash_messages::add_message('s', 'Project added successfully!');
        return flash_messages::display_message($request, $url = "owner/project");
        
           
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
             flash_messages::add_message('e', 'Unable to add Project. Please try again!'.$exp);
        return flash_messages::display_message($request, $url = "back");
            
           
        }
        
        
        
        
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
      // check_permission('owner_project|view_project');
        
        $row = Project::findOrFail($id);

      
        return view('owner.project.show', [
            'row' => $row,
           
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       //check_permission('owner_project|edit_project');

        $row = Project::findOrFail($id);
      
     
        return view('owner.project.edit', [
            'row' => $row,
            
          
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
      // check_permission('owner_project|edit_project');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $project = Project::find($id); */

        $v = Validator::make($data, [
                     'title' => ['required', 'string', 'min:2', 'max:100'],
                    'category' => ['required', 'string', 'min:2', 'max:50'],
                    'description' => ['required', 'string'],
                    'status' => ['required', 'integer', 'max:99'],
                    'project_image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           
                flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            
            
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }



        
        
       
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard('owner')->user()->id;
    //  dd($userid);

        
        
   $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');

        $project = Project::findorfail($id);
        //$project->assignRole($request->role);
    $project->title = $request->title;
        $project->category = $request->category;
        $project->description = $request->description;  
        $project->status = $request->status;
        $project->updated_by = $userid;
        $project->updated_at = $current_timestamp;
        $project->created_by = $userid;
        $project->created_at = $current_timestamp;
       

        $project->save();

        $project_id = $id;

        if ($request->hasFile('project_image')) {
            $file = $request->file('project_image');
            $time = time();
            if ($file->isValid()) {

                $filename_to_delete = storage_path() . '/app/' . $project->image;
                @unlink($filename_to_delete);

                $ext = strtolower($file->extension());
                $file_name = "img" . "_" . $project_id . "_" . $time . "." . $ext;
                $path = $file->storeAs('project/project_image', $file_name);
                // dd($path);
                $project->image = $path;
                $project->save();
                // save in database
            }
        }

                DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
                flash_messages::add_message('s','Updated successfully!');
                return flash_messages::display_message($request, $url = "back");
            
         
            
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
            flash_messages::add_message('e', 'Unable to update project details. Please try again!'.$exp);
            return flash_messages::display_message($request, $url = "back");   
           
        }
         
        
        
        
        
        
        
        
        
       
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
      // check_permission('owner_project|delete_project');
        
        $row = Project::where('id', $id)->first();
        if ($row->role == 'owner' || $row->role == 'superadmin') {
            return redirect('owner/project')->with('error', 'This can not be deleted');
        }
        $row->status = '2';
        $row->save();
        return redirect('owner/project')->with('success', 'Project deleted successfully!');
    }


}
