<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Session;

use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\Document as Document;

use DB;

use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;
use Carbon\Carbon;


use Illuminate\Support\Facades\Storage;

class DocumentController extends OwnerBaseController {

    public function __construct(Store $session){
        parent::__construct($session);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//


 //check_permission('owner_document|view_document');
        return view('owner.document.index');
    }

    public function document_grid(Request $req) {
     //  check_permission('owner_document|view_document');
       
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
        $search_coloumns = ['name'];
        if (!empty($search_term)) {
            $rows = Document::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })->where('id', '>=', 1)
                   
                  
                    ->paginate($limit);
        } else {
            
            $rows = Document::where('id', '>=', 1)
                 
                 
                    ->paginate($limit);
        }
//dd($rows);
        return view('owner.document.document_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       //check_permission('owner_document|create_document');
        
       $documents = Document::where('status',1)->get();
        return view('owner.document.create', [
          'documents'=>$documents,
        ]);
    }


    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
      // check_permission('owner_document|create_document');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'name' => ['required', 'string', 'min:2', 'max:100'],                 
                    'status' => ['required', 'integer', 'max:99'],
                    'file' => 'required|mimes:pdf,doc,docx,xls,xlsx|max:5120|min:10',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
            
           flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

       

        
        
        
        
        
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard($this->guard_name)->user()->id;
    //  dd($userid);

        

        $document = new Document();
        
        $document->name = $request->name;
      
        $document->status = $request->status;
      
      $document->save();

      

        if ($document->id){
            $document_id = $document->id;
            if ($request->hasFile('file')) {
                $file = $request->file('file');
                
                
                $time = time();
                if ($file->isValid()) {
                      $ext = strtolower($file->extension());
                    $file_name = "file" . "_" . $document_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('document', $file_name);
                    // Get the extension (guessed by the server based on content)
        //$extension = $file->extension(); 

        // Get the original extension provided by the client
        $originalExtension = $file->getClientOriginalExtension(); 
                    $document->path = $path;
                    $document->extension = $ext;
                    $document->save();
                }
            }
            
          
            
            
        }
        
      DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
     flash_messages::add_message('s', 'Saved successfully!');
        return flash_messages::display_message($request, $url = "owner/document");
        
           
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
             flash_messages::add_message('e', 'Unable to add Image. Please try again!'.$exp);
        return flash_messages::display_message($request, $url = "back");
            
           
        }
        
        
        
        
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
      // check_permission('owner_document|view_document');
        
        $row = Document::findOrFail($id);

      
        return view('owner.document.show', [
            'row' => $row,
           
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       //check_permission('owner_document|edit_document');

        $row = Document::findOrFail($id);
      
     $documents = Document::where('status',1)->get();
        return view('owner.document.edit', [
            'row' => $row,
            'documents' => $documents,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
      // check_permission('owner_document|edit_document');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $document = Document::find($id); */

        $v = Validator::make($data, [
                     'name' => ['required', 'string', 'min:2', 'max:100'],
                                   
                    'status' => ['required', 'integer', 'max:99'],
                    'file' => 'file|mimes:pdf,doc,docx,xls,xlsx|max:5120|min:10',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           
                flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            
            
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        try {
             DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction

               $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');
               $userid = Auth::guard('owner')->user()->id;
           //  dd($userid);



          $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');

               $document = Document::findorfail($id);
               //$document->assignRole($request->role);
                $document->name = $request->name;
                
               $document->status = $request->status;
              

              $document->save();

               $document_id = $id;
               
                
               if ($request->hasFile('file')) {
                   $file = $request->file('file');
                   $time = time();
                   if ($file->isValid()) {
//                        $filename_to_delete = storage_path() . '/app/private/' . $document->image;
//  dd($filename_to_delete);
                       $filename_to_delete = storage_path() . '/app/private/' . $document->path;
                     
                       @unlink($filename_to_delete);

                       $ext = strtolower($file->extension());
                       $file_name = "file" . "_" . $document_id . "_" . $time . "." . $ext;
                       $path = $file->storeAs('document', $file_name);
                       // dd($path);
                       $document->path = $path;
                       $document->extension = $ext;
                       $document->save();
                       // save in database
                   }
               }

                       DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
                       flash_messages::add_message('s','Updated successfully!');
                       return flash_messages::display_message($request, $url = "back");



               } catch(\Exception $exp) {
                   DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                   flash_messages::add_message('e', 'Unable to update details. Please try again!'.$exp);
                   return flash_messages::display_message($request, $url = "back");   

               }
         
    }
    
    
     public function download_file($path=''){
       //  dd('afafafafaf0');
      //  $path = 'documents/' . $filename; // Assuming files are in 'storage/app/public/documents'
 
        if($path != "" && Storage::exists($path)) {
      //  dd('trueeeeeee');
       // return url('storage/app/private/' . $path);
         return Storage::download($path);
    }
//        if (Storage::disk('public')->exists($path)) {
//            return Storage::disk('public')->download($path, $filename);
//        }

        return back()->with('error', 'File not found.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
      // check_permission('owner_document|delete_document');
        
        $row = Document::where('id', $id)->first();
      
        $row->status = '2';
        $row->save();
        return redirect('owner/document')->with('success', 'Document deleted successfully!');
    }


}
