<?php

namespace App\Http\Controllers\owner\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
//use App\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
//use Auth;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use DB;
use Carbon\Carbon;
use App\models\Owner;
use Response;
use App\Helpers\flash_messages;
use App\Models\Board as ModelsBoard;
use Illuminate\Validation\Rule;
use View;
use App\Models\School;
use App\Models\Board;
use App\Models\SchoolOwner;
use App\Models\SchoolRole;
use App\Models\Section;
use App\Models\geography\City;
use App\Models\rbac\Role;
use App\Models\rbac\UserRole;
use App\Models\Package;
use App\Models\PackageModule;
use App\Models\SchoolSubscribedModule;

class OwnerRegisterController extends Controller {

    /**
     * Create a new controller instance.
     *
     * @return void
     */
   // use Register;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
   // protected $redirectTo = RouteServiceProvider::OWNERHOME;

    public function __construct() {
        //  $this->middleware('auth');
    }

    protected function guard() {
        return Auth::guard('owner');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index() {
        $packages = Package::with('package_module', 'package_module.module')->where('status', 1)->get();
        // dd($packages);
        $boards = Board::where('status', '=', 1)->get();
        return view('owner.auth.register', [
            'packages' => $packages,
            'boards' => $boards,
        ]);
    }

    protected function validator(array $data) {
        return Validator::make($data, [
                    'name' => ['required', 'string', 'max:255'],
                    'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
                    'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    public function check_unique_email($email, $id = 0) {
        $row = Owner::where('email', $email)->where('id', "!=", $id)->first();
        return $row;
    }

    public function check_unique_conatct_number($mobile, $id = 0) {
        $row = Owner::where('mobile', $mobile)->where('id', "!=", $id)->first();
        return $row;
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
//    protected function register_submit(Request $request)
//    {
//        $user =  Owner::create([
//            'name' => $request['name'],
//            'email' => $request['email'],
//            'password' => Hash::make($request['password']),
//        ]);
//        Auth::login($user);
//       // dd(Auth::check());
//        //Auth::login($user);
////         if(Auth::login($user))   {
////   return redirect('owner/dashboard')->with('success','School added successfully!');
////         }
//        return redirect('owner/dashboard')->with('success','School added successfully!');
//    }

    public function owner_registration_submit(Request $request) {
        $data = $request->all();
       // dd($data);

        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'name' => ['required', 'string', 'min:2', 'max:100'],
                    'email' => ['required', 'string', 'email', 'max:128', Rule::unique("users")->ignore('2', 'status')],
                    'mobile' => ['required', 'string', 'min:10', 'max:10', Rule::unique("users")->ignore('2', 'status')],
                    'password' => ['required', 'min:8', 'max:128'],
                    //  'password_confirmation'=>['required','min:8','max:128'],
                    
                    'school_name' => ['required', 'string', 'min:2', 'max:100'],
                    'school_email' => ['required', 'string', 'email', 'max:128'],
                    'medium' => ['required', 'integer'],
                    'board' => ['required', 'integer'],
                    'school_address' => ['required', 'string','min:2', 'max:255'],
                    'school_pincode' => ['required', 'string','min:2', 'max:255'],
                    'school_sections' => ['required', 'integer','min:1', 'max:99'],
                    'school_contact' => ['required', 'string', 'min:10', 'max:10'],
                    //  'role' => ['required'],
                    'logo' => 'image|mimes:jpeg,jpg,png|max:2048',
                    'package' => ['required', 'integer'],
                    'terms' => ['required', 'in:1', 'accepted'],
                        ],
                        [
                            'terms.required' => 'Terms not accepted',
        ]);

        //dd($v->errors());
        if ($v->fails()) {
            if ($request->ajax()) {
                flash_messages::add_message('e', $v->errors()->all());
                return flash_messages::display_message(true);
            }
            return redirect()->back()->with('error', $v->errors()->all());
        }

        // dd($v->errors()->all());
        $check_email = $this->check_unique_email($data['email'], $id = 0);
        if (!empty($check_email->email)) {
            $status = config('constants.USER_STATUS');
            $state = $status[$check_email['status']];
            if ($request->ajax()) {
                flash_messages::add_message('e', 'This email already taken and in ' . $state . ' State. Kindly contact Administrator');
                return flash_messages::display_message(true);
            }
            return redirect()->back()->with('error', 'This email already taken and in ' . $state . ' State. Kindly contact Administrator');
        }

        $check_mobile = $this->check_unique_conatct_number($data['mobile'], $id = 0);
        if (!empty($check_mobile->conatct_number)) {
            $status = config('constants.USER_STATUS');
            $state = $status[$check_mobile['status']];
            if ($request->ajax()) {
                flash_messages::add_message('e', 'This Contact number already registered and in ' . $state . ' State. Kindly contact Administrator');
                return flash_messages::display_message(true);
            }
            return redirect()->back()->with('error', 'This Contact number already registered and in ' . $state . ' State. Kindly contact Administrator');
        }

        
         $current_timestamp = Carbon::now();
         $today = $current_timestamp->format('Y-m-d');
        //    $user_id = Auth::guard('owner')->user()->id;  

  
        try {
            DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
         
            // Call other functions, they're still part of this transaction
            // firts save users table data
//dd($data);
            $user = new Owner();
            $user->name = $data['name'];
            $user->mobile = $data['mobile'];
            $user->email = $data['email'];

            $verifiacation_srting = generate_random_string(64);
            $user->email_verification_code = $verifiacation_srting;
            $user->email_verified = 1;
            //$user->mobile_verified = "0";
            $user->ip_address = ip2long($_SERVER['REMOTE_ADDR']);
            $user->registered_from = "1"; // 1 - Web, 2 - Android, 3 - IOS, 4 - Admin
            $user->password = Hash::make($data['password']);
            $user->role_group = "owner";
            $user->role = "owner";
            $user->role_id = 2;
            $user->guard = "owner";
            $user->status = "1";

            $user->save();

            $employee_unique_id_length = 8;

            $user_unique_id = 'O' . str_pad($user->id, $employee_unique_id_length, '0', STR_PAD_LEFT);
            $user->user_unique_id = $user_unique_id;

            $user->save();

            if ($user->id) {
                $user_id = $user->id;
                $user_role = new UserRole();
                $user_role->user_id = $user_id;
                $user_role->role_id = 2;
                $user_role->save();

                $this->send_thanks_email_to_owner($user);

//     $exploded = explode('|', $request->school_city);
//        $country_id = $exploded[0];
//        $state_id = $exploded[1];
//        $city_id = $exploded[2];
//        $owner_id = Auth::guard('owner')->user()->id;
                $owner_id = $user_id;
                $school = new School();
                $school->school_name = $request->school_name;
                $school->created_by = $owner_id;
                $school->school_email = $request->school_email;
                $school->school_contact = $request->school_contact;
                $school->school_board = $request->board;
                $school->school_medium = $request->medium;

                $school->school_address = $request->school_address;
//        $school->school_country = $country_id;
//        $school->school_state = $state_id;
//        $school->school_city = $city_id;
                $school->school_pincode = $request->school_pincode;
                $school->status = 1;
                $school->registered_from = 1;

                $school->save();

                if ($school->id) {
                    $school_id = $school->id;

                    $school_owner = new SchoolOwner();
                    $school_owner->school_id = $school_id;
                    $school_owner->owner_id = $owner_id;
                    $school_owner->save();

                    ;
                    if (!empty($request->roles) && count($request->roles) > 0) {
                        $this->sync_school_roles($request, $school_id);
                    }


                    if ($request->hasFile('logo')) {
                        $file = $request->file('logo');
                        $time = time();
                        if ($file->isValid()) {

                            $filename_to_delete = storage_path() . '/app/' . $school->school_logo;
                            @unlink($filename_to_delete);

                            $ext = strtolower($file->extension());
                            $file_name = "logo" . "_" . $school_id . "_" . $time . "." . $ext;
                            $path = $file->storeAs('school/logo', $file_name);
                            // dd($path);
                            $school->school_logo = $path;
                            $school->save();
                            // save in database
                        }
                    }


                    $section_array = $this->create_section_array(1);

                 
                    
                    
                  $section_array = $this->create_section_array($data['school_sections']);
 // dd($section_array); 
            $section_insert_array = array();
             foreach($section_array as $section){
               $sec_array = [
                  'school_id'=>$school_id, 
                  'name'=>$section,
                  'description'=>'Section '.$section,
                  'status'=>1,
                  'slug'=>$school_id.'_'.$section,
                  'updated_by'=>$owner_id,
                  'updated_at'=>$current_timestamp,
                  'created_by'=>$owner_id,
                  'created_at'=>$current_timestamp,                  
               ];               
              array_push($section_insert_array,$sec_array);
           }
       
      //  dd($section_insert_array);
        $sections_save =  Section::insert($section_insert_array);   
        
        
         $package_id = $data['package'];
         $package_modules = PackageModule::where('package_id',$package_id)->pluck('module_id');
      
          $subscribed_modules_insert_array = array();

           foreach($package_modules as $module_id){
               $module_insert_array = [
                  'school_id'=>$school_id, 
                  'package_id'=>$package_id, 
                  'module_id'=>$module_id,
                  
               ];
               
              array_push($subscribed_modules_insert_array,$module_insert_array);
              
           }
        
        $subscribed_modules =  SchoolSubscribedModule::insert($subscribed_modules_insert_array);
                    
                }
            }


        
//        if ($package->id) {
//            $package_id = $package->id;
//            
//              $insert_array = array();
//              $package_total = 0;
//           foreach($package_modules as $module_id=>$rate){
//               $pack_array = [
//                  'package_id'=>$package_id, 
//                  'module_id'=>$module_id,
//               ];
//               
//              array_push($insert_array,$pack_array);
//              
//              $package_total = $package_total + $rate;
//           }
//       
//       // dd($insert_array);
//        $package->package_total = $package_total;
//        $package->package_modules = json_encode($insert_array);
//
//        $package->save();
//           
//        $package_modules_save =  PackageModule::insert($insert_array); 
//        
//        
//        } 
//        



            DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
            
         Auth::login($user);
            
            if ($request->ajax()) {
                flash_messages::add_message('s', 'Registration successfull please check your email and confirm!');
                return flash_messages::display_message(true);
            }
            return redirect('owner/dashboard')->with('success', 'Registration successfull please check your email and confirm!');
        } catch (\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
            if ($request->ajax()) {
                flash_messages::add_message('e', 'Unable to Save.All data rolled back. Please try again!' . $exp);
                return flash_messages::display_message(true);
            }
            return redirect()->back()->with('error', 'Unable to Save.All data rolled back. Please try again!!');
        }








//        $user->save();
//        $user->assignRole("vendor");
//
//        $this->send_thanks_email_to_vendor($user);
//        
    }

    public function create_section_array($number_of_section = 1) {
        // Number of iterations
        $iterations = $number_of_section;

// Initialize the alphabet array
        $alphabet = range('A', 'Z');

// Counter for the current iteration
        $currentIteration = 0;

// Initialize the results array
        $results = [];

// Loop through the desired number of iterations
        while ($currentIteration < $iterations) {
            if ($currentIteration < count($alphabet)) {
                // Single-character output for the first 26 iterations
                $output = $alphabet[$currentIteration];
            } else {
                // Two-character output after 26 iterations
                $firstIndex = intval(($currentIteration - count($alphabet)) / count($alphabet));
                $secondIndex = ($currentIteration - count($alphabet)) % count($alphabet);
                $output = $alphabet[$firstIndex] . $alphabet[$secondIndex];
            }

            // Store the result in the array
            $results[] = $output;

            // Increment the iteration counter
            $currentIteration++;
        }

// Return the result as an array
        return ($results);
    }

    public function sync_school_roles($request, $school_id) {
        //  dd($request->post());
        $data = $request->all();

        if (!empty($data['roles']) && count($data['roles']) > 0) {
            $roles = $data['roles'];
            $delete_existing = SchoolRole::where('school_id', '=', $school_id)->delete();

            $insert_data = array();
            foreach ($roles as $role) {

                $insert_one = array('school_id' => $school_id, 'role_id' => $role);
                array_push($insert_data, $insert_one);
            }

            $save = SchoolRole::insert($insert_data);
            // dd($save);
            if ($save) {
                return true;
            } else {
                return false;
            }
        } else {
            $check_existing = SchoolRole::where('school_id', '=', $school_id)->get();
            if (!empty($check_existing) && count($check_existing) > 0) {
                $delete_existing = SchoolRole::where('school_id', '=', $school_id)->delete();
                return true;
            } else {
                return false;
            }
        }
    }

    public function send_verification_mail(Request $request) {
        $user = Auth::guard('owner')->user();
        // dd($user);
        if ($user) {
            $this->send_thanks_email_to_owner($user);
        }
        return redirect()->back()->with('success', 'Verification Mail sent to registered email address!');
    }

    public function send_thanks_email_to_owner($user) {
        // send email to user
        //         send email to user
        $to = $user->email;
        $subject = 'Thanks for Registering with us';
        $view = \View::make('templates/emails/owner_email_confirmation', ['email' => $user->email, 'row' => $user]);
        $body = $view->render();

        $data['from'] = array(env('MAIL_USERNAME') => env('EMAIL_SENDER'));
        $data['to'] = $to;
        $data['subject'] = $subject;
        $data['body'] = $body;
        // dd($data);
        //dd($data);
        try {
//            Mail::send([], [], function($message) use ($data) {
//                $message->from($data['from']);
//                $message->to($data['to']);
//                $message->subject($data['subject']);
//                $message->setBody($data['body'], 'text/html');
//            });

            return back()->with('error', 'mail function is disable in development mode');
        } catch (\Exception $e) {
            //dd($e);
            return redirect()->back()->withError('Oops! Some error occured in sending email.');
        }
    }
}
