<?php

namespace App\Http\Controllers\owner\Auth;

use App\Helpers\flash_messages;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Cookie;

class LoginController extends Controller
{
    //
    public function index(){
        
        return view('owner.auth.login');
    }

     public function authenticate(Request $request){
       // dd($request->all());
        $validator = Validator::make($request->all(),[
            'email'=>'required|email',
            'password'=>'required',
        ]);

        if($validator->passes()){

            if(Auth::guard('owner')->attempt(['email'=>$request->email,'password'=>$request->password])){
                if(Auth::guard('owner')->user()->guard != 'owner'){
                    Auth::guard('owner')->logout();
                     flash_messages::add_message('e', 'Invalid login credentials. You are not authorised to access this page');
                    return flash_messages::display_message($request, $url = "back");    
                     //return redirect()->back()->withInput()->with('error','Invalid login credentials. You are not authorised to access this page');
                }
                    $user = Auth::guard('owner')->user();
//                 dd($user->school_id);
                  Session::put('current_school_id', $user->school_id);
             //   $current_sch_id = Session::get('current_school_id');   ;
               //   dd($current_sch_id);
                $app_session = Cookie::get('app_session');
                if ($app_session == "") {
                    $app_session = generate_random_string(64);
                     Cookie::queue(Cookie::make('app_session', $app_session, config('constants.COOKIE_LIFETIME')));
                }
                $user_session = $app_session;


                    flash_messages::add_message('s', 'Login Successfull.');
                    return flash_messages::display_message($request, $url = "back"); 

                //  return redirect()->route('owner.dashboard')->with('success','Login Successfull.'); 
            }else{
                 flash_messages::add_message('e', 'Invalid login credentials.');
                    return flash_messages::display_message($request, $url = "back");    
             //  return redirect()->back()->with('error','Invalid login credentials.'); 
            }
//dd('asdasdasd');
        }else{
            //  if($request->ajax()){
            //         flash_messages::add_message('e', $validator->errors());
            //          return flash_messages::display_message(true);
            // }    
               flash_messages::add_message('e', $validator->errors()->all());
            return flash_messages::display_message($request, $url = "back");     

            return redirect()->back()->withInput()->withErrors($validator);
        }


    }

    public function logout(Request $request){
        Auth::guard('owner')->logout();
         flash_messages::add_message('s', 'Logged out.');
        return flash_messages::display_message($request); 
        
        return redirect()->route('owner.login')->with('success','Logout Successfully.'); 
    }

}
